<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use \WP_Query;
use Elementor\Group_Control_Image_Size;
extract($data);

$args = array(
	'post_type'      => 'finbuzz_testim',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_testimonial_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );

if($data['slider_autoplay']=='yes'){
$data['slider_autoplay']=true;
}
else{
$data['slider_autoplay']=false;
}
    
$swiper_data = array(
        'slidesPerView' 	=>2,
        'loop'				=>$data['slider_loop']=='yes' ? true:false,
        'spaceBetween'		=>$data['space']['size'],
        'slidesPerGroup'	=>$data['slider_per_group']['size'],
        'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
        'slideToClickedSlide' =>true,
        'autoplay'				=>array(
            'delay'  => $data['autoplayspeed']['size'],
        ),
        'speed'      =>$data['speed']['size'],
        'breakpoints' =>array(
            '0'    =>array('slidesPerView' =>1),
            '576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
            '768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
            '992'    =>array('slidesPerView' =>$data['medium_item']['size']),
            '1200'    =>array('slidesPerView' =>$data['item']['size']),				
            '1600'    =>array('slidesPerView' =>$data['item']['size'])
        ),
        'auto'   =>$data['slider_autoplay']
    );

$swiper_data = json_encode( $swiper_data );
?>
<div class="rt-fin-testimonial-wrap">
    <div class="rt-fin-testimonial-slider position-relative testimonial-slider-<?php echo esc_attr( $data['style'] );?>">
        <div class="rt-fin-testimonial-slider-wrap swiper-container">
            <?php if ( $query->have_posts() ) {?>
            <div class="swiper-wrapper">
                <?php while ( $query->have_posts() ) { $query->the_post();
                    $id 			= get_the_id();
                    $designation 	= get_post_meta( $id, 'finbuzz_tes_designation', true );
                    $content 		= FinbuzzTheme_Helper::get_current_post_content();
                    $content 		= wp_trim_words( $content, $data['count'], '' );
                    $content 		= "<p>$content</p>";
                    $ratting	 	= get_post_meta( $id, 'finbuzz_tes_rating', true );
                    $rest_testimonial_rating = 5- intval( $ratting ) ;
                ?>
                <div class="swiper-slide">
                    <div class="rt-fin-testimonial-box d-md-flex align-items-center">
                        <?php if ( $data['thumbs_display']  == 'yes' ) { ?>
                            <?php if ( has_post_thumbnail() ) { ?>
                                <div class="item-img w-100"><?php the_post_thumbnail($data['testimonial_image_size'] );?></div>
                            <?php } ?>
                        <?php } ?>
                        <div class="content">
                            <div class="quote-shape">
                                <svg width="60" height="47" viewBox="0 0 60 47" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M14.5185 21.7318C12.3556 21.7391 10.2309 22.303 8.34903 23.3692C10.9986 16.5112 15.393 10.4638 21.0974 5.82561C21.4238 5.55682 21.694 5.22639 21.8927 4.85316C22.0914 4.47994 22.2146 4.07124 22.2553 3.65039C22.2961 3.22955 22.2535 2.8048 22.1301 2.4004C22.0066 1.99601 21.8048 1.61988 21.536 1.2935C21.2672 0.967123 20.9368 0.696877 20.5635 0.4982C20.1903 0.299523 19.7816 0.176304 19.3608 0.135577C18.9399 0.0948499 18.5152 0.137415 18.1108 0.260838C17.7064 0.384262 17.3303 0.586127 17.0039 0.854911C5.30813 10.3577 0.103516 23.5154 0.103516 31.6732C0.123668 34.5577 0.983242 37.3738 2.57728 39.7779C4.17133 42.1819 6.43086 44.0698 9.08001 45.2111C10.7945 46.0416 12.672 46.481 14.577 46.4976C16.2538 46.5791 17.9296 46.3192 19.503 45.7337C21.0763 45.1482 22.5143 44.2492 23.7298 43.0914C24.9453 41.9335 25.9131 40.5408 26.5743 38.9978C27.2355 37.4547 27.5764 35.7935 27.5764 34.1147C27.5764 32.436 27.2355 30.7747 26.5743 29.2317C25.9131 27.6886 24.9453 26.296 23.7298 25.1381C22.5143 23.9802 21.0763 23.0813 19.503 22.4957C17.9296 21.9102 16.2538 21.6503 14.577 21.7318H14.5185Z" fill="currentColor"/>
                                    <path d="M47.0908 21.7317C44.9275 21.7364 42.8022 22.3005 40.9213 23.3691C43.5698 16.5182 47.9526 10.4729 53.6404 5.82549C53.9964 5.56888 54.2962 5.24213 54.5212 4.86535C54.7462 4.48856 54.8917 4.06973 54.9487 3.6346C55.0058 3.19948 54.9732 2.75728 54.853 2.33522C54.7328 1.91316 54.5275 1.52017 54.2497 1.18043C53.9719 0.840687 53.6275 0.561388 53.2377 0.35972C52.848 0.158052 52.4211 0.0382824 51.9833 0.00777919C51.5455 -0.022724 51.1061 0.0366852 50.6921 0.182352C50.2782 0.32802 49.8984 0.556862 49.5762 0.854796C37.8804 10.3576 32.6758 23.5153 32.6758 31.6731C32.6896 34.5249 33.5241 37.3124 35.0796 39.7027C36.6351 42.0929 38.8458 43.9848 41.4476 45.1525C43.2055 46.0073 45.1361 46.4475 47.0908 46.439C48.7676 46.5205 50.4434 46.2606 52.0167 45.6751C53.5901 45.0896 55.0281 44.1906 56.2436 43.0328C57.4591 41.8749 58.4268 40.4822 59.0881 38.9392C59.7493 37.3961 60.0902 35.7349 60.0902 34.0561C60.0902 32.3774 59.7493 30.7161 59.0881 29.1731C58.4268 27.63 57.4591 26.2374 56.2436 25.0795C55.0281 23.9216 53.5901 23.0227 52.0167 22.4371C50.4434 21.8516 48.7676 21.5917 47.0908 21.6732V21.7317Z" fill="currentColor"/>
                                </svg>
                            </div>
                            <div class="quote-wrap mb-3">
                                <div class="quote">
                                    <?php echo wp_kses_post( $content  );?>
                                </div>
                            </div>
                            <?php if( $data['ratting_display'] == 'yes' ) { ?>
                                <ul class="review-wrap d-flex align-items-center mb-4">
                                    <?php for ($i=0; $i < $ratting; $i++) { ?>
                                        <li>
                                            <svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.49958 14.2419L4.37929 16.8408C4.19727 16.9621 4.00698 17.0141 3.80841 16.9968C3.60984 16.9794 3.43609 16.9101 3.28717 16.7888C3.13824 16.6676 3.02241 16.5158 2.93967 16.3335C2.85694 16.1512 2.84039 15.9478 2.89003 15.7233L3.98216 10.8114L0.333471 7.5108C0.167998 7.35486 0.0647422 7.1771 0.0237048 6.9775C-0.0173325 6.77791 -0.00508757 6.58317 0.0604398 6.39327C0.126629 6.20269 0.225913 6.04675 0.358292 5.92547C0.49067 5.80419 0.672691 5.72623 0.904353 5.69157L5.71963 5.24976L7.5812 0.623734C7.66394 0.415823 7.79234 0.259889 7.96642 0.155934C8.1405 0.0519779 8.31822 0 8.49958 0C8.6816 0 8.85932 0.0519779 9.03273 0.155934C9.20615 0.259889 9.33456 0.415823 9.41795 0.623734L11.2795 5.24976L16.0948 5.69157C16.3265 5.72623 16.5085 5.80419 16.6409 5.92547C16.7732 6.04675 16.8725 6.20269 16.9387 6.39327C17.0049 6.58386 17.0175 6.77895 16.9764 6.97854C16.9354 7.17814 16.8318 7.35556 16.6657 7.5108L13.017 10.8114L14.1091 15.7233C14.1588 15.9485 14.1422 16.1523 14.0595 16.3346C13.9767 16.5168 13.8609 16.6683 13.712 16.7888C13.5631 16.9101 13.3893 16.9794 13.1907 16.9968C12.9922 17.0141 12.8019 16.9621 12.6199 16.8408L8.49958 14.2419Z" fill="currentColor"/>
                                            </svg>
                                        </li>
                                    <?php } ?>			
                                    <?php for ($i=0; $i < $rest_testimonial_rating; $i++) { ?>
                                        <li>
                                            <svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.49958 14.2419L4.37929 16.8408C4.19727 16.9621 4.00698 17.0141 3.80841 16.9968C3.60984 16.9794 3.43609 16.9101 3.28717 16.7888C3.13824 16.6676 3.02241 16.5158 2.93967 16.3335C2.85694 16.1512 2.84039 15.9478 2.89003 15.7233L3.98216 10.8114L0.333471 7.5108C0.167998 7.35486 0.0647422 7.1771 0.0237048 6.9775C-0.0173325 6.77791 -0.00508757 6.58317 0.0604398 6.39327C0.126629 6.20269 0.225913 6.04675 0.358292 5.92547C0.49067 5.80419 0.672691 5.72623 0.904353 5.69157L5.71963 5.24976L7.5812 0.623734C7.66394 0.415823 7.79234 0.259889 7.96642 0.155934C8.1405 0.0519779 8.31822 0 8.49958 0C8.6816 0 8.85932 0.0519779 9.03273 0.155934C9.20615 0.259889 9.33456 0.415823 9.41795 0.623734L11.2795 5.24976L16.0948 5.69157C16.3265 5.72623 16.5085 5.80419 16.6409 5.92547C16.7732 6.04675 16.8725 6.20269 16.9387 6.39327C17.0049 6.58386 17.0175 6.77895 16.9764 6.97854C16.9354 7.17814 16.8318 7.35556 16.6657 7.5108L13.017 10.8114L14.1091 15.7233C14.1588 15.9485 14.1422 16.1523 14.0595 16.3346C13.9767 16.5168 13.8609 16.6683 13.712 16.7888C13.5631 16.9101 13.3893 16.9794 13.1907 16.9968C12.9922 17.0141 12.8019 16.9621 12.6199 16.8408L8.49958 14.2419Z" fill="currentColor"/>
                                            </svg>
                                        </li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                            <div class="author-name">
                                <?php the_title(); ?>
                            </div>
                            <?php if($data['designation_display']  == 'yes' && $designation ){ ?>
                                <div class="degination"><?php echo wp_kses_post( $designation );?></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
            <?php } ?>
        </div>
        <?php if($data['navigation']=='yes'){ ?>                        
        <div class="swiper-button-next">
            <svg width="26" height="20" viewBox="0 0 26 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M16.25 19.75L13.975 17.3937L19.7437 11.625H0V8.375H19.7437L13.975 2.60625L16.25 0.25L26 10L16.25 19.75Z" fill="currentColor"/>
            </svg>
        </div>
        <div class="swiper-button-prev">
            <svg width="26" height="20" viewBox="0 0 26 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9.75 19.75L12.025 17.3937L6.25625 11.625H26V8.375H6.25625L12.025 2.60625L9.75 0.25L0 10L9.75 19.75Z" fill="currentColor"/>
            </svg>
        </div>
        <?php } ?>
    </div>
</div>