<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use \WP_Query;

extract($data);

$args = array(
	'post_type'      => 'finbuzz_testim',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_testimonial_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );

if($data['slider_autoplay']=='yes'){
$data['slider_autoplay']=true;
}
else{
$data['slider_autoplay']=false;
}
    
$swiper_data = array(
        'slidesPerView' 	=>2,
        'loop'				=>$data['slider_loop']=='yes' ? true:false,
        'spaceBetween'		=>$data['space']['size'],
        'slidesPerGroup'	=>$data['slider_per_group']['size'],
        'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
        'slideToClickedSlide' =>true,
        'autoplay'				=>array(
            'delay'  => $data['autoplayspeed']['size'],
        ),
        'speed'      =>$data['speed']['size'],
        'breakpoints' =>array(
            '0'    =>array('slidesPerView' =>1),
            '576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
            '768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
            '992'    =>array('slidesPerView' =>$data['medium_item']['size']),
            '1200'    =>array('slidesPerView' =>$data['item']['size']),				
            '1600'    =>array('slidesPerView' =>$data['item']['size'])
        ),
        'auto'   =>$data['slider_autoplay']
    );

$swiper_data = json_encode( $swiper_data );
?>

<div class="default-testimonial  testimonial-slider-<?php echo esc_attr( $data['style'] );?> finbuzz-horizontal-slider">
    <div class="swiper-container horizontal-slider" data-xld ="<?php echo esc_attr( $swiper_data );?>">
        <?php if ( $query->have_posts() ) {?>
            <div class="swiper-wrapper">
                <?php while ( $query->have_posts() ) { $query->the_post();?>
                    <?php
                    $id 			= get_the_id();
                    $designation 	= get_post_meta( $id, 'finbuzz_tes_designation', true );
                    $content 		= FinbuzzTheme_Helper::get_current_post_content();
                    $content 		= wp_trim_words( $content, $data['count'], '' );
                    $content 		= "<p>$content</p>";
                    $ratting	 	= get_post_meta( $id, 'finbuzz_tes_rating', true );
                    $rest_testimonial_rating = 5- intval( $ratting ) ;
                    ?>
                    <div class="swiper-slide">
                        <div class="testimonial-item rt-slide">
                            <div class="testimonial-content">
                                <div class="qoute-icon">
                                    <svg width="110" height="82" viewBox="0 0 110 82" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M86.4286 33.3H109.5V81.5H63.3571V32.9136L78.8863 0.5H101.349L85.9777 32.584L85.6346 33.3H86.4286ZM23.5714 33.3H46.6429V81.5H0.5V32.9136L16.0292 0.5H38.4917L23.1205 32.584L22.7775 33.3H23.5714Z" stroke="#BDBDBD"/>
                                    </svg>
                                </div>
                                <div class="tcontent"><?php echo wp_kses_post( $content  );?></div>
                                <div class="heading">
                                    <h3 class="testimonial-title"><?php the_title(); ?></h3>
                                    <div class="shape"></div>
                            </div>
                                <?php if($data['designation_display']  == 'yes' && $designation ){ ?>
                                    <span class="testimonial-designation"><?php echo wp_kses_post( $designation );?></span>
                                <?php } ?>
                                <?php if( $data['ratting_display'] == 'yes' ) { ?>
                                    <ul class="rating">
                                        <?php for ($i=0; $i < $ratting; $i++) { ?>
                                            <li class="star-rate"><i class="fa fa-star" aria-hidden="true"></i></li>
                                        <?php } ?>			
                                        <?php for ($i=0; $i < $rest_testimonial_rating; $i++) { ?>
                                            <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                        <?php } ?>
                                    </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                </div>
        <?php } ?>
    </div>
    <!-- end video-slider-style-1 -->
    <!-- start video-thumnail-area -->
    <?php if ( $data['thumbs_display']  == 'yes') { ?>
        <div class="rt-thumnail-area ">
            <div class="swiper-container swiper-item-wrap horizontal-thumb-slider" data-xld ="<?php echo esc_attr( $swiper_data );?>">
            <?php if ( $query->have_posts() ) {?>
                <div class="swiper-wrapper">
                    <?php while ( $query->have_posts() ) { $query->the_post();?>
                        <div class="swiper-slide">
                            <div class="item-thumb">
                                <?php if ( has_post_thumbnail() ) { ?>
                                    <div class="testimonial-thumb"><?php the_post_thumbnail( 'thumbnail' );?></div>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } 
                    ?>        
                </div>
            <?php } ?>    
            </div>
        </div>
    <?php } ?>
    <?php if($data['navigation']=='yes'){ ?>
        <div class="swiper-navigation">
            <div class="swiper-button-next">
            <i class="fa fa-angle-right"></i></div>
            <div class="swiper-button-prev"><i class="fa fa-angle-left"></i></div>
        </div>
	<?php } ?>
</div>