<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Rotate_Animation extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Rotate Animation', 'finbuzz-core' );
		$this->rt_base = 'rt-rotate-animation';
		parent::__construct( $data, $args );
	}
	
	private function rt_load_scripts(){
		wp_enqueue_script( 'rt-wow' );
	}	
	
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),

			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rotate_image',
				'label'   => esc_html__( 'Rotate Image', 'finbuzz-core' ),
			),

			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'normal_image',
				'label'   => esc_html__( 'Normal Image', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),


			// Style Area
			array(
				'mode'    => 'section_start',
				'id'      => 'shape1_style',
				'label'   => esc_html__( 'Custom Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'outside_image',
				'label'       => esc_html__( 'Outside Width', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'min' => 80,
						'max' => 300,
					],
				],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .medel-shape-box .about-shape' => 'width: {{SIZE}}px;',
                ],

			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'outside_image_h',
				'label'       => esc_html__( 'Outside Height', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'min' => 80,
						'max' => 300,
					],
				],
                'size_units' => [ 'px'],
                'selectors' => [
					'{{WRAPPER}} .medel-shape-box .about-shape' => 'height: {{SIZE}}px;',
                ],

			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'intside_image',
				'label'       => esc_html__( 'Inside Width', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 200,
					],
				],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .medel-shape-box .medel-shape' => 'width: {{SIZE}}px;',
                ],

			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'intside_image_h',
				'label'       => esc_html__( 'Inside Hidth', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 200,
					],
				],
                'size_units' => [ 'px'],
                'selectors' => [
					'{{WRAPPER}} .medel-shape-box .medel-shape' => 'height: {{SIZE}}px;',
                ],

			),
			array(
				'mode' => 'section_end',
			),

		);
		return $fields;
	}
	protected function render() {
        $data = $this->get_settings();
        $template = 'rotate-animation';
        return $this->rt_template( $template, $data );
    }
}