<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Icons_Manager;


if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Counter extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT Counter', 'finbuzz-core' );
		$this->rt_base = 'rt-counter';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'appear' );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'iconalign',
				'label'   => esc_html__( 'Counter Align', 'finbuzz-core' ),
				'options' => array(
					'left' => esc_html__( 'left', 'finbuzz-core' ),
					'center' => esc_html__( 'Center', 'finbuzz-core' ),
					'right' => esc_html__( 'Right', 'finbuzz-core' ),
				),
				'default' => 'left',
				'condition'   => array( 'style' => array('style1','style3')),
			),
			
			/*Icon Start*/

			array(
				'type'        => Controls_Manager::ICONS,
				'id'        => 'icon',
				'label'       => esc_html__( 'Icon', 'medimall-core' ),
				'description' => esc_html__( 'Select icon', 'medimall-core' ),
				'default'     => [
					'value'   => 'fas  fa-angle-right icon',
					'library' => 'fa-solid',
				],
				'condition' =>array('style'=>array('style6'))
			),
			
			

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label_block'=>true,
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Organizations & Financial', 'finbuzz-core' ),
			),
			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Counter Number', 'finbuzz-core' ),
				'default' => 3000,
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'num_prefix',
				'label_block'=>true,
				'label'   => esc_html__( 'Number Prefix', 'finbuzz-core' ),
				'condition' =>array('style'=>array('style6')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'num_suffix',
				'label_block'=>true,
				'label'   => esc_html__( 'Number Suffix', 'finbuzz-core' ),
				'condition' =>array('style'=>array('style6')),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'speed',
				'label'   => esc_html__( 'Animation Speed', 'finbuzz-core' ),
				'default' => 2000,
				'description' => esc_html__( 'The total duration of the count animation in milisecond eg. 5000', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'content_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .counter-style2 .success-count-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .counter-style4 .success-count-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .counter-style5 .success-count-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' =>array('style'=>array('style2','style4','style5'))
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'content_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Margin', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .counter-style5 .count' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' =>array('style'=>array('style5'))
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'title_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Title Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .counter-style4 .success-count-wrap .count-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' =>array('style'=>array('style2','style4'))
			),
			array(
				'mode' => 'section_end',
			),

			// Style Section
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_colors',
				'label'   => esc_html__( 'Colors', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .count-text span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style4 .success-count-wrap .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .progress-Inner .item-label' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'counter_color',
				'label'   => esc_html__( 'Counter Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .counterUp' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .plus' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style4 .success-count-wrap .count' => 'color: {{VALUE}}',
					'{{WRAPPER}} .progress-Inner .rt_number-count' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'counter_bg_color',
				'label'   => esc_html__( 'Counter Background', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style2' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .counter-style4' => 'background-color: {{VALUE}}',
				),
				'condition'=>array('style'=>array('style2','style4'))
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_size',
				'mode'       => 'responsive',
				'label'   => esc_html__( 'Title Font Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style4 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .progress-Inner .item-label' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'counter_size',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Counter Font Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .counterUp' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style5 .success-count-wrap .count .plus' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style4 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .progress-Inner .rt_number-count' => 'font-size: {{VALUE}}px',
				),
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color6',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-fin-progress-box .item-icon svg' => 'color: {{VALUE}}',
				),
				'condition'=>array('style'=>array('style6'))
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_border_color6',
				'label'   => esc_html__( 'Icon Border Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-fin-progress-box .item-icon' => 'border-color: {{VALUE}}',
				),
				'condition'=>array('style'=>array('style6'))
			),

			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_bg_color6',
				'label'   => esc_html__( 'Icon BG Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-fin-progress-box .item-icon' => 'background-color: {{VALUE}}',
				),
				'condition'=>array('style'=>array('style6')),
			),

			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'icon_height',
				'label'   		=> esc_html__( 'Height', 'finbuzz-core' ),
				'size_units' => array( 'px' ),
				 'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 200,
				 ],
			   ],
				'selectors' => array(
					'{{WRAPPER}} .rt-fin-progress-box .item-icon' => 'height: {{SIZE}}{{UNIT}};',						
				),
				'condition'=>array('style'=>array('style6')),
				
			),

			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'icon_width',
				'label'   		=> esc_html__( 'Width', 'finbuzz-core' ),
				'size_units' => array( 'px' ),
				 'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 200,
				 ],
			   ],
				'selectors' => array(
					'{{WRAPPER}} .rt-fin-progress-box .item-icon' => 'width: {{SIZE}}{{UNIT}};',						
				),
				'condition'=>array('style'=>array('style6')),
				
			),

			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['style'] ) {
			case 'style6':
			$template = 'counter-6';
			break;
			case 'style5':
			$template = 'counter-5';
			break;
			case 'style4':
			$template = 'counter-4';
			break;
			case 'style3':
			$template = 'counter-3';
			break;
			case 'style2':
			$template = 'counter-2';
			break;
			default:
			$template = 'counter-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}