<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//title url

$title_attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$title_attr  = 'href="' . $data['title_url']['url'] . '"';
	$title_attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$title_attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $title_attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

$btn = '<a class="btn-style4" ' . $attr . '>' .'+'.'<span>' . esc_html__('Read More','finbuzz-core') . '</span>'. '</a>';

// icon , image
if ( $attr ) {
  $getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'icon_image');
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'icon_image' );
}

$final_icon_class       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $icon_class['value'] ) ) {
  $final_icon_image_url = $icon_class['value']['url'];
}

$circle_image = Group_Control_Image_Size::get_attachment_image_html( $data,'info_circle_image_size','info_circle_image' );
$circle_hover_image = Group_Control_Image_Size::get_attachment_image_html( $data,'info_circle_image_size','info_circle_hover_image' );

$infobox_border=$data['border_right'];
if($infobox_border=='show'){
	$border_class="show-border";
}else{
	$border_class="hide-border";
}

?>
<div class="info-box info-<?php echo esc_attr( $data['style'] );?> <?php echo esc_attr( $border_class ); ?>">
	<div class="info-item  media-<?php echo esc_attr( $data['icontype'] );?>">
		<div class="info-content media-body">
			<div class="icon-circle-image">
				<div class="hover-image">
					<?php if($circle_hover_image){ ?>
						<?php echo wp_kses_post($circle_hover_image);?>
					<?php } else{ ?>
					  <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/circle_active.svg'; ?>" height="82" width="82" alt="figure">
					<?php } ?>
				</div>
				  <?php if($circle_image){ ?>
				  	<?php echo wp_kses_post($circle_image);?>
				  <?php } else{ ?>
					  <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/circle_inactive.svg'; ?>" height="82" width="82" alt="figure">
				<?php } ?>
				 <div class="icon-image">
				<?php if ( !empty( $data['icontype']== 'image' ) ) { ?>		            
					<span class="info-img"><?php echo wp_kses_post($getimg);?></span>  
				<?php }else{?> 
				</div>	
				<div class="icon-body">
					<?php if ( $final_icon_image_url ): ?>
						<span class="info-icon"><img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon"></span>
					<?php else: ?>
						<span class="info-icon"><i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i></span>
					<?php endif ?>
				<?php }  ?>
				</div>
			</div>	
			<?php if ( !empty( $data['title'] ) ) { ?>
				<h3 class="info-title"><?php echo wp_kses_post( $title );?></h3>
			<?php } ?>
			<?php if ( !empty( $data['content'] ) ) { ?>
				<p class="info-text">
					<?php echo wp_kses_post( $data['content'] ); ?>
			    </p>
			<?php  } ?>
			<?php if ( $data['button_display']  == 'yes' ) { ?>
			<?php if ( !empty( $btn ) ){ ?>
				<div class="info-button"><?php echo wp_kses_post( $btn );?></div>		
			<?php } } ?>
		</div>
	</div>
</div>