<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thumb_size = 'finbuzz-size5';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
	'posts_per_page' => $number_of_post,
	'paged'          => $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";
?>
<div class="rt-business-strategy-wrap portfolio-<?php echo esc_attr( $data['layout'] );?>">
	<div class="rt-business-strategy rt-post-count-<?php echo $number_of_post; ?>">	
		<?php $j = $data['delay']; $k = $data['duration'];
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {

				$query->the_post();	
				$id 		= get_the_ID();
				$content 	= wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
				$portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );			
				$content = wp_trim_words( $content, $data['excerpt_count'], '' );
				$finbuzz_port_no  = get_post_meta( $id, 'portfolio_serial_num', true );
		?>
		<div class="business-strategy-box">
			<?php
				if ( has_post_thumbnail() ){ ?>
					<div class="portfolio-image" style="background-image: url(<?php the_post_thumbnail_url(); ?>)"></div>
				<?php } 
			?>
			<div class="inner">
				<div class="sub-title d-flex align-items-center">
				<?php if ( $data['cat_display'] ) { ?>
					<?php
						$i = 1;
						$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
						if($term_lists){
							foreach ( $term_lists as $term_list ){ 
							$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } 
							
				} } ?>
				<span class="title-bar1"></span>
				<span class="title-bar2"></span>
				</div>
				<h3 class="title"><?php echo wp_kses($portfolio_title,'alltext_allow');?></h3>
				<div class="hover-content">
					<?php if ($data['excerpt_display']=='yes' ) { ?>
					  <p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
					<?php } ?>
					<?php if ( $data['view_portfolio_link_btn'] ) { ?>	
						<div class="fin-button">
							<a href="<?php the_permalink();?>" class="fin-btn"><?php esc_html_e('Read More','finbuzz-core'); ?>
								<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24">
									<path fill="currentColor" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"></path>
								</svg>
							</a>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>			
		<?php $j = $j + 0.2;  } ?>
	<?php } ?>
	</div>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>