<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$finbuzz_has_entry_meta  = ( $data['post_grid_author'] || $data['post_grid_category'] == 'yes' || $data['post_grid_comment'] == 'yes' || $data['post_grid_view'] == 'yes' || $data['post_grid_date']=='yes' && function_exists( 'finbuzz_views' ) || $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) ? true : false;

$thumb_size = 'finbuzz-size4';

$args = array(
	'posts_per_page' 	=> $data['itemlimit'],
	'cat'            	=> (int) $data['cat'],
	'order' 			=> $data['post_ordering'],
	'orderby' 			=> $data['post_orderby'],
);

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>
<div class="post-default post-grid-style5 post-multi-grid">
	<div class="row auto-clear">
	<?php $i = 1;
	 $j = $data['delay']; $k = $data['duration'];
	 if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
			<?php
			$content = FinbuzzTheme_Helper::get_current_post_content();
			$content = wp_trim_words( get_the_excerpt(), $data['count'], '' );
			$content = "<p>$content</p>";
			$title = wp_trim_words( get_the_title(), $data['title_count'], '' );
			
			$finbuzz_comments_number = number_format_i18n( get_comments_number() );
			$finbuzz_comments_html = $finbuzz_comments_number == 1 ? esc_html__( 'Comment: ' , 'finbuzz-core' ) : esc_html__( 'Comments: ' , 'finbuzz-core' );
			$finbuzz_comments_html = $finbuzz_comments_html . '<span class="comment-number">'. $finbuzz_comments_number . '</span> ';
			
			$finbuzz_time_html = sprintf( '<span>%s</span> <span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );

			if ( empty(has_post_thumbnail() ) ) {
				$img_class ='no_image';
			}else {
				$img_class ='show_image';
			}
			?>
			<div class="<?php  echo esc_attr( $col_class );?>">
				<div class="rtin-item-post rt-animate <?php echo esc_attr($img_class);?> <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $j );?>s" data-wow-duration="<?php echo esc_attr( $k );?>s">
					<div class="rtin-img">
						<?php if ( has_post_thumbnail() ) { ?>
						<a href="<?php the_permalink(); ?>">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_520X350.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							?>
						</a>
						<?php } ?>
                        <?php  if ( $data['read_display'] == 'yes' ) { ?>
                            <div class="blog-button"><a href="#" class="blog-btn"><i class="fas fa-arrow-right"></i></a></div>
                        <?php } ?>
					</div>
					<div class="rtin-content">
						<?php if ( $finbuzz_has_entry_meta ) { ?>
						<ul class="post-grid-meta">
                            <?php if ( $data['post_grid_date'] == 'yes' ) { ?>
                            <li class="blog-date">	
                                <i class="far fa-calendar-alt"></i><?php echo get_the_date(); ?>
                                </li>
                            <?php }  ?>
                            <?php  if ( $data['post_grid_author'] == 'yes' ) { ?>
							<li class="item-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'finbuzz-core' );?><?php the_author_posts_link(); ?></li>
                            <?php } if ( $data['post_grid_category'] == 'yes' ) { ?>
							<li class="blog-cat"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
							<?php } if ( $data['post_grid_comment'] == 'yes' ) { ?>
							<li class="item-comment"><i class="far fa-comments"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses_post( $finbuzz_comments_html );?></a></li>
							<?php } if ( $data['post_grid_view'] == 'yes' && function_exists( 'finbuzz_views' ) ) { ?>
							<li><i class="fas fa-signal"></i><span class="meta-views meta-item "><?php echo finbuzz_views(); ?></span></li>
							<?php } if ( $data['post_grid_read'] == 'yes' && function_exists( 'finbuzz_reading_time' ) ) { ?>
							<li class="meta-reading-time meta-item"><i class="far fa-clock"></i><?php echo finbuzz_reading_time(); ?></li>
							<?php } ?>
						</ul>
						<?php } ?>
						<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php echo esc_html( $title );?></a></h3>						
						<?php if ( $data['content_display'] == 'yes' ) { ?>
						<?php echo wp_kses_post( $content );?>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php $i++; $j = $j + 0.3; $k = $k + 0.2; endwhile;?>
	</div>
	<?php endif;?>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp );?>
</div>