<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$args = array(
	'post_type'      => 'finbuzz_testim',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_testimonial_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );

if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);
$swiper_data = json_encode( $swiper_data );

?>
<div class="default-testimonial testimonial-7">
	<div class="rt-mousewheel-slider" data-xld = '<?php echo esc_attr( $swiper_data );?>'>
		<?php if ( $query->have_posts() ) :?>
            <div class="swiper-wrapper">
                <?php while ( $query->have_posts() ) : $query->the_post();?>
                    <?php
                    $id 			= get_the_id();
                    $designation 	= get_post_meta( $id, 'finbuzz_tes_designation', true );
                    $content 		= FinbuzzTheme_Helper::get_current_post_content();
                    $content 		= wp_trim_words( $content, $data['count'], '' );
                    $content 		= "<p>$content</p>";
                    $ratting	 	= get_post_meta( $id, 'finbuzz_tes_rating', true );
                    $rest_testimonial_rating = 5- intval( $ratting ) ;
                    ?>
                    <div class="swiper-slide <?php echo esc_attr( $data['navigation'] ); ?>">
                        <div class="testimonial-item">
                            <div class="qoute-icon">
                                <i class="fas fa-quote-right"></i>
                                <div class="item-line"></div>
                            </div>
                            <div class="testimonial-wrapper">
                                <div class="test-author">
                                    <div class="testimonial-figure">
                                        <?php if ( $data['thumbs_display']  == 'yes' ) { ?>
                                            <?php if ( has_post_thumbnail() ) { ?>
                                                <div class="testimonial-thumb"><?php the_post_thumbnail( 'thumbnail' );?></div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                    <div class="author-info">
                                        <h5 class="testimonial-title"><?php the_title(); ?></h5>
                                        <?php if ( $data['designation_display']  == 'yes' && $designation ) { ?><div class="testimonial-designation"> <?php echo esc_html( $designation );?></div><?php } ?>
                                        <?php if ( $data['ratting_display']  == 'yes' ) { ?>
                                            <ul class="rating">
                                                <?php for ($i=0; $i < $ratting; $i++) { ?>
                                                    <li class="star-rate"><i class="fa fa-star" aria-hidden="true"></i></li>
                                                <?php } ?>			
                                                <?php for ($i=0; $i < $rest_testimonial_rating; $i++) { ?>
                                                    <li><i class="fa fa-star" aria-hidden="true"></i></li>
                                                <?php } ?>
                                            </ul>
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="testimonial-content">
                                    <?php echo wp_kses_post( $content ); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile;?>
            </div>
            <?php if($data['navigation']=='yes'){ ?>
                <div class="swiper-pagination"></div>
        <?php } ?>
		<?php endif;?>
		<?php wp_reset_query();?>
	</div>
</div>
