<?php
/**
 * This file can be overridden by copying it to yourtheme/elementor-custom/about-box/class.php
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;


if ( ! defined( 'ABSPATH' ) ) exit;

class Pricing_Tab extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Pricing Tab', 'finbuzz-core' );
		$this->rt_base = 'rt-pricing-tab';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'top_icon',
			[
				'type'    => Controls_Manager::ICONS,
				'label'   => esc_html__( 'Icon', 'finbuzz-core' ),
			]	
		);
		$repeater->add_control(
			'title',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => 'Basic Plan',
			]
		);
		
		$repeater->add_control(
			'most_popular',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Most Popular', 'finbuzz-core' ),
			]
		);
		$repeater->add_control(
			'monthly_price',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Monthly Price', 'finbuzz-core' ),
				'default' => '$19',
			]
		);
		$repeater->add_control(
			'yearly_price',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Yearly Price', 'finbuzz-core' ),
				'default' => '$60',
			]
		);
		$repeater->add_control(
			'content',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => 'Popularised in the follower with the etraset sheets containing.',
			]
		);

		$repeater->add_control(
			'plan_highlights',[
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Plan Highlights', 'finbuzz-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_item',
			 [
				'type'    => Controls_Manager::WYSIWYG,
				'label'   => esc_html__( 'Pricing List', 'finbuzz-core' ),
			]
		);
		$repeater->add_control(
			'btn_text',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Get Started', 'finbuzz-core' ),
				'default' => 'Get Started',
			]
		);
		$repeater->add_control(
			'btn_link',
			 [
				'type'    => Controls_Manager::URL,
				'label'   => esc_html__( 'Button Link', 'finbuzz-core' ),
			]
		);
		$fields = array(
			array(
				'id'      => 'sec_general',
				'mode'    => 'section_start',
				'label'   => __( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Layout 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Layout 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Layout 3', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'id'      => 'save_upto',
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Save Upto', 'finbuzz-core' ),
				'default' => 'Save Upto 50%',
				'label_block' => true,
				'condition'   => array('style' => array('style2', 'style3')),
			), 
			
			array(

				'id'      => 'right_icon',
				'label' => esc_html__( 'Right Icon Show/Hide', 'textdomain' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'textdomain' ),
				'label_off' => esc_html__( 'Hide', 'textdomain' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition'   => array('style' => array('style2', 'style3')),
			),
	 
			// Monthly
			array(
				'id'      => 'monthly_heading',
				'type' => Controls_Manager::HEADING,
				'label'   => __( 'Monthly', 'finbuzz-core' ),
				'separator' => 'before',
			),
			array(
				'id'      => 'monthly_label',
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Label', 'finbuzz-core' ),
				'default' => 'MONTHLY',
				'label_block' => true,
			),      
			// Yearly 
			array(
				'id'      => 'yearly_heading',
				'type' => Controls_Manager::HEADING,
				'label'   => __( 'Yearly', 'finbuzz-core' ),
				'separator' => 'before',
			),
			array(
				'id'      => 'yearly_label',
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Label', 'finbuzz-core' ),
				'default' => 'YEARLY',
				'label_block' => true,
			),
			
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'prices_infos',
				'label'   => esc_html__( 'Add Plan', 'finbuzz-core' ),
				'fields' => $repeater->get_controls(),
				'default' => array(
					['title' => 'Basic Plan', ],
					['title' => 'Standard Plan', ],
					['title' => 'Premium Plan', ],
				),
			),
			array(
				'mode' => 'section_end',
			),

			/*Style Shape*/
			array(
				'mode'    => 'section_start',
				'id'      => 'content_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style2', 'style3')),
			),
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .fin-price-box .label',
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box .label' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box p' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'price_color',
				'label'   => esc_html__( 'Price Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box .price-box .pricing__price' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'btn_color',
				'label'   => esc_html__( 'Button Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box .pricing-button .pricing-btn' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'btn_bg',
				'label'   => esc_html__( 'Button Background', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box .pricing-button .pricing-btn' => 'background-color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'btn_hover_color',
				'label'   => esc_html__( 'Button Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box:hover .pricing-button .pricing-btn' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'btn_hover_bg',
				'label'   => esc_html__( 'Button Hover Background', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box:hover .pricing-button .pricing-btn' => 'background-color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'badge_color',
				'label'   => esc_html__( 'Badge Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box .badge' => 'color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'badge_bg_color',
				'label'   => esc_html__( 'Badge Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .fin-price-box .badge' => 'background-color: {{VALUE}}',
				),
				'separator' => 'before',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		
		switch ( $data['style'] ) {
			case 'style3':
			$template = 'pricing-tab-3';
			break;
			case 'style2':
			$template = 'pricing-tab-2';
			break;
			default:
			$template = 'pricing-tab';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}