<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use \RT_Posts;
use FinbuzzTheme;


if ( ! class_exists( 'RT_Posts' ) ) {
	return;
}

$team_admin_title        = FinbuzzTheme::$options['team_admin_title'] ?: 'Team';
$service_admin_title     = FinbuzzTheme::$options['services_admin_title'] ?: 'Service';
$portfolio_admin_title   = FinbuzzTheme::$options['portfolios_admin_title'] ?: 'Portfolio';
$testimonial_admin_title = FinbuzzTheme::$options['testimonials_admin_title'] ?: 'Testimonial';
$gallery_admin_title     = FinbuzzTheme::$options['galleries_admin_title'] ?: 'Gallery';

$post_types = array(
	'finbuzz_team'         => array(
		'title'           => __( $team_admin_title, 'finbuzz-core' ),
		'plural_title'    => __( $team_admin_title, 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-businessman',
		'labels_override' => array(
			'menu_name' => __( $team_admin_title, 'finbuzz-core' ),
		),
		'rewrite'         => FinbuzzTheme::$options['team_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' )
	),
	'finbuzz_service'      => array(
		'title'        => __( $service_admin_title, 'finbuzz-core' ),
		'plural_title' => __( $service_admin_title, 'finbuzz-core' ),
		'menu_icon'    => 'dashicons-book',
		'rewrite'      => FinbuzzTheme::$options['service_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	'finbuzz_portfolio'    => array(
		'title'        => __( $portfolio_admin_title, 'finbuzz-core' ),
		'plural_title' => __( $portfolio_admin_title, 'finbuzz-core' ),
		'menu_icon'    => 'dashicons-book',
		'rewrite'      => FinbuzzTheme::$options['portfolio_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	'finbuzz_testim'       => array(
		'title'        => __( $testimonial_admin_title, 'finbuzz-core' ),
		'plural_title' => __( $testimonial_admin_title, 'finbuzz-core' ),
		'menu_icon'    => 'dashicons-awards',
		'rewrite'      => FinbuzzTheme::$options['testimonial_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	),
	'finbuzz_logoshowcase' => array(
		'title'        => __( 'Logo', 'finbuzz-core' ),
		'plural_title' => __( 'Logos', 'finbuzz-core' ),
		'menu_icon'    => 'dashicons-slides',
		'rewrite'      => FinbuzzTheme::$options['logoshowcase_slug'],
		'supports'     => array( 'title', 'thumbnail', 'excerpt', 'page-attributes' ),
	),
	'finbuzz_gallery'      => array(
		'title'        => __( $gallery_admin_title, 'finbuzz-core' ),
		'plural_title' => __( $gallery_admin_title, 'finbuzz-core' ),
		'menu_icon'    => 'dashicons-format-gallery',
		'rewrite'      => FinbuzzTheme::$options['gallery_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
);

$taxonomies = array(
	'finbuzz_team_category'        => array(
		'title'        => __( $team_admin_title . ' Category', 'finbuzz-core' ),
		'plural_title' => __( $team_admin_title . ' Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_team',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['team_cat_slug'] ),
	),
	'finbuzz_service_category'     => array(
		'title'        => __( $service_admin_title . ' Category', 'finbuzz-core' ),
		'plural_title' => __( $service_admin_title . ' Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_service',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['service_cat_slug'] ),
	),
	'finbuzz_portfolio_category'   => array(
		'title'        => __( $portfolio_admin_title . ' Category', 'finbuzz-core' ),
		'plural_title' => __( $portfolio_admin_title . ' Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_portfolio',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['portfolio_cat_slug'] ),
	),
	'finbuzz_testimonial_category' => array(
		'title'        => __( $testimonial_admin_title . ' Category', 'finbuzz-core' ),
		'plural_title' => __( $testimonial_admin_title . ' Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_testim',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['testim_cat_slug'] ),
	),
	'finbuzz_gallery_category'     => array(
		'title'        => __( $gallery_admin_title . ' Category', 'finbuzz-core' ),
		'plural_title' => __( $gallery_admin_title . ' Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_gallery',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['gallery_cat_slug'] ),
	),
);

$Posts = RT_Posts::getInstance();
$Posts->add_post_types( $post_types );
$Posts->add_taxonomies( $taxonomies );