<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
$btn = $attr = '';
$svg='<svg 
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        width="24px" height="24px">
        <path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
        d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
        </svg>';
$shape_img=wp_get_attachment_image( $data['shape1']['id'],'full');

?>

<div class="banner-slider-addon slider-<?php echo esc_attr( $data['style'] ); ?>">
    <div class="main-banner-slider3  swiper-container" data-options ="<?php echo esc_attr( $data['swiper_data'] );?>">
        <div class="swiper-wrapper">
            <?php
                foreach ($data['items'] as $item){ ?>
                   
                <div class="swiper-slide single-slide slide-1">
                    <ul class="banner-element-shape  d-xl-block">
                        <li>
                        <?php if($data['shape1_display']=='yes'){?>
                            <?php if($shape_img): ?>
                                <?php echo wp_kses_post($shape_img);?>
                                <?php else: ?>
                                    <img width="1200" height="900" src="<?php echo FINBUZZ_ASSETS_URL . 'element/banner-slider3-shape.png'; ?>" alt="">	
                            <?php endif;
                            }
                        ?>
                        </li>
                    </ul>
                    <div class="single-slider" data-bg-image="<?php echo esc_attr($item['img']['url']); ?>">
                        <div class="container">
                            <div class="row d-flex align-items-center">
                                <div class="col-xl-7 col-lg-8 col-md-10">
                                    <div class="banner-content layout-1">
                                        <?php 
                                            $btn = $attr = '';
                                            extract($item);
                                            if ( !empty( $url['url'] ) ) {
                                                $attr  = 'href="' . $url['url'] . '"';
                                                $attr .= !empty( $url['is_external'] ) ? ' target="_blank"' : '';
                                                $attr .= !empty( $url['nofollow'] ) ? ' rel="nofollow"' : '';
                                            }
                                            if ( !empty( $item['btn'] ) ) {
                                                $btn = '<a class="btn-style3" ' . $attr . '>' . $item['btn'] .$svg.'</a>';
                                            }
                                            
                                        ?>
                                        <?php if($item['sub-title']) { ?>
                                            <span class="banner-subtitle">
                                                <?php echo wp_kses_post($item['sub-title']) ?>
                                            </span>
                                        <?php } ?>
                                        <?php if($item['title']) { ?>
                                            <h2 class="banner-title">
                                                <span class="anim-overflow"><?php echo wp_kses_post($item['title']) ?></span>
                                            </h2>
                                        <?php } ?>
                                        <?php if($item['desc']) { ?>
                                        <p>
                                            <span class="anim-overflow">
                                                <?php echo wp_kses_post($item['desc']) ?>
                                            </span>
                                        </p>
                                        <?php } ?>
                                        <div class="slider3-btn-wrap">
                                            <div class="anim-overflow">
                                                <ul class="slider3-btn-list flex-wrap gutter-40">
                                                    <?php if($item['btn']) { ?>
                                                        <li class="btn-list">
                                                            <?php echo wp_kses_post( $btn );?>
                                                        </li>
                                                    <?php } if($item['video_url']['url']){ ?>
                                                    
                                                    <li class="btn-list">
                                                        <a href="<?php echo esc_url($item['video_url']['url'] );?>"
                                                            class="play-btn rt-video-popup">
                                                            <span class="play-icon style-1">
                                                                <i class="fas fa-play"></i>
                                                            </span>
                                                            <span class="play-text"><?php echo esc_html($item['video_text']); ?></span>
                                                        </a>
                                                    </li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            
        </div>
        <?php if($data['display_arrow']=='yes'){  ?>
            <div class="swiper-navigation">
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        <?php } ?>
    </div>
    
</div>

<?php


