<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use radiustheme\Lib\WP_SVG;
use Elementor\Utils;
use Elementor\Icons_Manager;



?>

<div class="rt-fin-progress-box counter-appear">
    <div class="item-icon overflow-hidden mb-3">
        <?php Icons_Manager::render_icon( $data['icon'], [ 'aria-hidden' => 'true' ] ); ?>
    </div>
    <div class="progress-Inner">
        <div class="rt_number-count">
            <?php if(!empty($data['num_prefix'])){?>
                <span class="plus"><?php echo esc_html( $data['num_prefix'] );?></span>
            <?php } ?>

            <span class="counterUp" data-counter="<?php echo esc_html( $data['number'] );?>"> <?php echo esc_html( $data['number'] );?> </span>
            <?php if(!empty($data['num_suffix'])){?>
            <span class="plus"><?php echo esc_html( $data['num_suffix'] );?></span>
            <?php } ?>
        </div>
        <div class="item-label"><?php echo wp_kses_post($data['title'] );?></div>
    </div>
</div>
