<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
	
}

//title url

$title_attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$title_attr  = 'href="' . $data['title_url']['url'] . '"';
	$title_attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$title_attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $title_attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
} ?>

<div class="rt-communication-box d-flex align-items-center">
	<?php if ( !empty($data['icon']) ) { ?>
	<div class="shape-wrap">
		<span class="icon">
			<?php Icons_Manager::render_icon( $data['icon'], [ 'aria-hidden' => 'true' ] ); ?>
		</span>
	</div>
	<?php } ?>
	<div class="content">
		<?php if ( !empty( $data['title'] ) ) { ?>
			<div class="text"><?php echo wp_kses_post( $title );?></div>
		<?php } ?>
		<?php if ( !empty( $data['content'] ) ) { ?>
			<div class="contact"><?php echo wp_kses_post( $content );?></div>
		<?php } ?>
	</div>
</div>
