<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
	'posts_per_page' => $number_of_post,
	'paged'          => $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>
<div class="portfolio-default portfolio-multi-layout-6 portfolio-<?php echo esc_attr( $data['layout'] );?>">
	<div class="row rt-portfolio-masonary <?php echo esc_attr( $data['item_space'] ); ?>">	
		<?php $j = $data['delay']; $k = $data['duration'];
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
				$query->the_post();	
				$id 		= get_the_ID();
				$excerpt = wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
				$portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );
								
		?>
		<div class="<?php  echo esc_attr( $col_class ) ?> rt-portfolio-item ">
			<div class="rtin-item <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $j );?>s" data-wow-duration="<?php echo esc_attr( $k );?>s">
				<div class="rtin-figure">
					<a href="<?php the_permalink(); ?>">
						<?php
							if ( has_post_thumbnail() ){
								the_post_thumbnail( 'full', ['class' => 'img-fluid mb-10 width-100'] );
							} else {
								if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], 'full' );
								} else {
									echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						?>
					</a>
				</div>
				<div class="rtin-content">
					<?php if ( $data['cat_display'] == 'yes' ) { ?>
					<div class="rtin-cat"><?php
						$i = 1;
						$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
						if($term_lists){
						foreach ( $term_lists as $term_list ){ 
						$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?>
						</a><?php $i++; } }?>
					</div>
					<?php } ?>
					<h3>
						<?php if($data['view_display'] == 'yes'){ ?>
							<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id() ); ?>" class="img-popup-icon"  data-elementor-open-lightbox="yes" data-elementor-lightbox-slideshow="1" data-elementor-lightbox-title="<?php echo get_the_title(); ?>"><span><?php echo wp_kses($portfolio_title,'alltext_allow');?></span></a>
						<?php } else {?>
							<a href="<?php the_permalink(); ?>"><span><?php echo wp_kses($portfolio_title,'alltext_allow');?></span></a>
						<?php } ?>	
						
					</h3>
					<?php if ( $data['excerpt_display'] == 'yes' ) { ?>
					<p><span><?php echo wp_kses( $excerpt , 'alltext_allow' ); ?></span></p>
					<?php } ?>
				</div>
				<?php if($data['view_portfolio_link_btn']=='yes'){ ?>
					<div class="portfolio-btn">
					<a href="<?php the_permalink();?>" class="read-more-btn"><i class="fas fa-long-arrow-alt-right"></i></a>
					</div>
				<?php } ?>
			</div>
		</div>
		<?php  $j = $j + 0.2; $k = $k + 0.2;  } ?>
	<?php } ?>
	</div>
    <?php if ( $data['more_button_display'] == 'yes' ) : ?>
        <?php if ( $data['more_button'] == 'show' ) { ?>
            <?php if ( !empty( $data['see_button_text'] ) ) { ?>
            <div class="portfolio-button"><a class="btn-style1" href="<?php echo esc_url( $data['see_button_link'] );?>"><?php echo esc_html( $data['see_button_text'] );?></a></div>
            <?php } ?>
        <?php } else { ?>
            <?php FinbuzzTheme_Helper::pagination(); ?>
        <?php } ?>
    <?php endif; ?>	
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>
<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
  <script>jQuery('.rt-portfolio-masonary').isotope();</script>
<?php }