<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Consalty_Core;
use ConsaltyTheme_Helper;
use Elementor\Group_Control_Image_Size;

//title url

$attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$attr  = 'href="' . $data['title_url']['url'] . '"';
	$attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

// image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'video_image' );

?>
<div class="rt-video video-<?php echo esc_attr( $data['style'] );?>">
	<div class="rtin-video">
		<div class="item-img">
		<?php echo wp_kses_post($getimg);?>
		</div>
		<div class="video-content">
			<div class="title">
				<h2><?php echo wp_kses_post( $title );?></h2>
			</div>
				<a class="rtin-play rt-video-popup" href="<?php echo esc_url( $data['videourl']['url'] );?>">
				<span class="play-icon"><i class="fas fa-play"></i></span>
				<span class="play-text"><?php echo esc_attr($data['video_title']); ?></span>
				</a>
		</div>
	</div>
</div>