<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

class FinbuzzTheme_Address_Widget extends WP_Widget {
	public function __construct() {
		parent::__construct(
            'finbuzz_address', // Base ID
            esc_html__( 'Finbuzz : Address', 'finbuzz-core' ), // Name
            array( 'description' => esc_html__( 'Address Widget', 'finbuzz-core' ) ) // Args
            );
	}

	public function widget( $args, $instance ){
		echo wp_kses_post( $args['before_widget'] );
		if ( !empty( $instance['title'] ) ) {
			$html = apply_filters( 'widget_title', $instance['title'] );
			echo $html = $args['before_title'] . $html .$args['after_title'];
		}
		else {
			$html = '';
		}
		?>
		<p class="rtin-des"><?php if( !empty( $instance['description'] ) ) echo wp_kses_post( $instance['description'] ); ?></p>
		<ul class="corporate-address">
			<?php
			if( !empty( $instance['working_time'] ) ){
				?><li><i class="far fa-clock"></i>

				<?php if( !empty( $instance['time_title'] ) ){ ?>
				<span><?php echo esc_html( $instance['time_title'] ); ?></span>
				<?php } ?>

				<?php echo esc_html( $instance['working_time'] ); ?>
				</li>
				<?php
			}  
			if( !empty( $instance['address'] ) ){
				?><li><i class="fas fa-map-marker-alt"></i>
				<?php if( !empty( $instance['address_title'] ) ){ ?>
				<span><?php echo esc_html( $instance['address_title'] ); ?></span>
				<?php } ?>
				<?php echo esc_html( $instance['address'] ); ?></li><?php
			}  
			if( !empty( $instance['phone'] ) ){
				?><li><i class="fas fa-phone-alt"></i> 
				<?php if( !empty( $instance['phone_title'] ) ){ ?>
				<span><?php echo esc_html( $instance['phone_title'] ); ?></span>
				<?php } ?>
				<a href="tel:<?php echo esc_attr( $instance['phone'] ); ?>"><?php echo esc_html( $instance['phone'] ); ?></a></li><?php
			}   
			if( !empty( $instance['email'] ) ){
				?><li><i class="far fa-envelope"></i>
				<?php if( !empty( $instance['email_title'] ) ){ ?>
				<span><?php echo esc_html( $instance['email_title'] ); ?></span>
				<?php } ?>
				<a href="mailto:<?php echo esc_attr( $instance['email'] ); ?>"><?php echo esc_html( $instance['email'] ); ?></a></li><?php
			}  
			if( !empty( $instance['fax'] ) ){
				?><li><i class="fa fa-fax" aria-hidden="true"></i>
				<?php if( !empty( $instance['fax_title'] ) ){ ?>
				<span><?php echo esc_html( $instance['fax_title'] ); ?></span>
				<?php } ?> 
				<?php echo esc_html( $instance['fax'] ); ?></li><?php
			}   
			?>
		</ul>

		<?php
		echo wp_kses_post( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ){
		$instance              = array();
		$instance['title']     = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['description']   = ( ! empty( $new_instance['description'] ) ) ? wp_kses_post( $new_instance['description'] ) : '';
		$instance['time_title']   = ( ! empty( $new_instance['time_title'] ) ) ? sanitize_text_field( $new_instance['time_title'] ) : '';
		$instance['working_time']   = ( ! empty( $new_instance['working_time'] ) ) ? sanitize_text_field( $new_instance['working_time'] ) : '';
		$instance['address_title']   = ( ! empty( $new_instance['address_title'] ) ) ? sanitize_text_field( $new_instance['address_title'] ) : '';
		$instance['address']   = ( ! empty( $new_instance['address'] ) ) ? sanitize_text_field( $new_instance['address'] ) : '';
		$instance['phone_title']     = ( ! empty( $new_instance['phone_title'] ) ) ? sanitize_text_field( $new_instance['phone_title'] ) : '';
		$instance['phone']     = ( ! empty( $new_instance['phone'] ) ) ? sanitize_text_field( $new_instance['phone'] ) : '';
		$instance['email_title']     = ( ! empty( $new_instance['email_title'] ) ) ? sanitize_email( $new_instance['email_title'] ) : '';
		$instance['email']     = ( ! empty( $new_instance['email'] ) ) ? sanitize_email( $new_instance['email'] ) : '';
		$instance['fax_title']       = ( ! empty( $new_instance['fax_title'] ) ) ? sanitize_text_field( $new_instance['fax_title'] ) : '';
		$instance['fax']       = ( ! empty( $new_instance['fax'] ) ) ? sanitize_text_field( $new_instance['fax'] ) : '';
		return $instance;
	}

	public function form( $instance ){
		$defaults = array(
			'title'   			=> esc_html__( 'Corporate Office' , 'finbuzz-core' ),
			'description'		=> '',
			'time_title'		=> '',
			'working_time'		=> '',
			'address_title'		=> '',
			'address'			=> '',
			'phone_title'   	=> '',
			'phone'   			=> '',
			'email_title'   	=> '',
			'email'   			=> '',
			'fax_title'     	=> '',  
			'fax'     			=> ''  
			);
		$instance = wp_parse_args( (array) $instance, $defaults );

		$fields = array(
			'title'     => array(
				'label' => esc_html__( 'Title', 'finbuzz-core' ),
				'type'  => 'text',
			),
			'description' => array(
				'label'   => esc_html__( 'Description', 'finbuzz-core' ),
				'type'    => 'textarea',
			),
			'time_title'   => array(
				'label' => esc_html__( 'Title Time', 'finbuzz-core' ),
				'type'  => 'text',
			),
			'working_time'   => array(
				'label' => esc_html__( 'Working Time', 'finbuzz-core' ),
				'type'  => 'text',
			),
			'address_title'   => array(
				'label' => esc_html__( 'Address Title', 'finbuzz-core' ),
				'type'  => 'text',
			),      
			'address'   => array(
				'label' => esc_html__( 'Address', 'finbuzz-core' ),
				'type'  => 'text',
			),     
			'phone_title'     => array(
				'label' => esc_html__( 'Phone Title', 'finbuzz-core' ),
				'type'  => 'text',
			),      
			'phone'     => array(
				'label' => esc_html__( 'Phone Number', 'finbuzz-core' ),
				'type'  => 'text',
			),      
			'email_title'     => array(
				'label' => esc_html__( 'Email Title', 'finbuzz-core' ),
				'type'  => 'text',
			),      
			'email'     => array(
				'label' => esc_html__( 'Email', 'finbuzz-core' ),
				'type'  => 'text',
			),      
			'fax_title'       => array(
				'label' => esc_html__( 'Fax Title', 'finbuzz-core' ),
				'type'  => 'text',
			),
			'fax'       => array(
				'label' => esc_html__( 'Fax', 'finbuzz-core' ),
				'type'  => 'text',
			),
		);

		RT_Widget_Fields::display( $fields, $instance, $this );
	}
}