<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="description" content="Hillcrest Capital Management">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<?php


		// Preloader
		if( !empty( FinbuzzTheme::$options['preloader_image'] ) ) {
			$pre_bg = wp_get_attachment_image_src( FinbuzzTheme::$options['preloader_image'], 'full', true );
			$preloader_img = $pre_bg[0];
		}else {
			$preloader_img = FINBUZZ_IMG_URL . 'preloader.gif';
		}
		if ( FinbuzzTheme::$options['preloader'] ) {
			if (!empty($preloader_img)) {                
                echo '<div id="preloader" class="img-pre-loader" style="background-image:url(' . esc_url($preloader_img) . ');"></div>';
            }
		}
		if(FinbuzzTheme::$header_style == 11){
			$header_class ="rt-header rt-header-style11 style-5 bg--white sticky-on d-none d-lg-block";
		}else{
			$header_class ="";
		}
		if ( FinbuzzTheme::$top_bar == 0 || FinbuzzTheme::$top_bar == 'off' ){ 
			$hide_topbar ="rt-hide-topbar";
		}else{
			$hide_topbar ="rt-on-topbar";
		}	
		
	?>
	<div id="page" class="site">		
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'finbuzz' ); ?></a>	
		<header id="masthead" class="site-header">			
			<div id="header-<?php echo esc_attr( FinbuzzTheme::$header_style ); ?>" class="header-area <?php echo esc_attr($header_class); ?> <?php echo esc_attr($hide_topbar); ?>">
				<?php if ( FinbuzzTheme::$top_bar == 1 || FinbuzzTheme::$top_bar === 'on' ){ ?>			
				<?php get_template_part( 'template-parts/header/header-top', FinbuzzTheme::$top_bar_style ); ?>
				<?php } ?>
				<?php if ( FinbuzzTheme::$header_opt == 1 || FinbuzzTheme::$header_opt === 'on' ){ ?>
				<?php get_template_part( 'template-parts/header/header', FinbuzzTheme::$header_style ); ?>
				<?php } ?>
			</div>
		</header>

		<?php get_template_part('template-parts/header/mobile', 'menu');?>
		<div id="header-search" class="header-search">
	            <button type="button" class="close">×</button>
				<form role="search" method="get" class="header-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	                <input type="search" value="<?php echo get_search_query(); ?>" name="s" placeholder="<?php esc_html_e( 'Search here........', 'finbuzz' ); ?>">
	                <button type="submit" class="search-btn">
	                    <i class="fas fa-search"></i>
	                </button>
	            </form>
	    </div>
		<div id="content" class="site-content">			
			<?php
				if ( FinbuzzTheme::$has_banner === 1 || FinbuzzTheme::$has_banner === "on" ) { 
					get_template_part('template-parts/content', 'banner');
				}
			?>

			