<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Separator_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Sortable_Repeater_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_General_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_general_controls' ) );
	}

    public function register_general_controls( $wp_customize ) {
        /**
         * Heading
         */
        $wp_customize->add_setting('logo_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'logo_heading', array(
            'label' => __( 'Site Logo', 'finbuzz' ),
            'section' => 'general_section',
        )));

        $wp_customize->add_setting( 'logo',
            array(
                'default' => $this->defaults['logo'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'logo',
            array(
                'label' => __( 'Main Logo', 'finbuzz' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'finbuzz' ),
                'section' => 'general_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => __( 'Select File', 'finbuzz' ),
                    'change' => __( 'Change File', 'finbuzz' ),
                    'default' => __( 'Default', 'finbuzz' ),
                    'remove' => __( 'Remove', 'finbuzz' ),
                    'placeholder' => __( 'No file selected', 'finbuzz' ),
                    'frame_title' => __( 'Select File', 'finbuzz' ),
                    'frame_button' => __( 'Choose File', 'finbuzz' ),
                )
            )
        ) );

        $wp_customize->add_setting( 'logo_light',
            array(
                'default' => $this->defaults['logo_light'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'logo_light',
            array(
                'label' => __( 'Logo Light', 'finbuzz' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'finbuzz' ),
                'section' => 'general_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => __( 'Select File', 'finbuzz' ),
                    'change' => __( 'Change File', 'finbuzz' ),
                    'default' => __( 'Default', 'finbuzz' ),
                    'remove' => __( 'Remove', 'finbuzz' ),
                    'placeholder' => __( 'No file selected', 'finbuzz' ),
                    'frame_title' => __( 'Select File', 'finbuzz' ),
                    'frame_button' => __( 'Choose File', 'finbuzz' ),
                )
            )
        ) );

        $wp_customize->add_setting( 'logo_width',
            array(
                'default' => $this->defaults['logo_width'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'logo_width',
            array(
                'label' => __( 'Logo Width', 'neeon' ),
                'section' => 'general_section',
                'description' => esc_html__( 'Default logo size 152x45px ( Input logo size only number widthout px )', 'neeon' ),
                'type' => 'number',
            )
        );

        $wp_customize->add_setting( 'mobile_logo_width',
            array(
                'default' => $this->defaults['mobile_logo_width'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'mobile_logo_width',
            array(
                'label' => __( 'Mobile Logo Width', 'neeon' ),
                'section' => 'general_section',
                'description' => esc_html__( 'Default logo size 115x45px ( Input logo size only number widthout px )', 'neeon' ),
                'type' => 'number',
            )
        );


        /**
         * Heading
         */
        $wp_customize->add_setting('site_switching', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'site_switching', array(
            'label' => __( 'Site Switch Control', 'finbuzz' ),
            'section' => 'general_section',
        )));
		
		$wp_customize->add_setting( 'container_width',
            array(
                'default' => $this->defaults['container_width'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization',
            )
        );
        $wp_customize->add_control( 'container_width',
            array(
                'label' => __( 'Container width( Bootstrap Grid )', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'select',
                'choices' => array(
                    '1350' => esc_html__( '1350px', 'finbuzz' ),
					'1240' => esc_html__( '1240px', 'finbuzz' ),
					'1200' => esc_html__( '1200px', 'finbuzz' ),
					'1170' => esc_html__( '1170px', 'finbuzz' ),
                ),
            )
        );
		
		// Display No Preview Image
        $wp_customize->add_setting( 'display_no_preview_image',
            array(
                'default' => $this->defaults['display_no_preview_image'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'display_no_preview_image',
            array(
                'label' => __( 'Display No Preview Image on Blog', 'finbuzz' ),
                'section' => 'general_section',
            )
        ) );
		
		// Display No Preview Image
        $wp_customize->add_setting( 'display_no_prev_img_related_post',
            array(
                'default' => $this->defaults['display_no_prev_img_related_post'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'display_no_prev_img_related_post',
            array(
                'label' => __( 'Display No Preview Image on Related Post', 'finbuzz' ),
                'section' => 'general_section',
            )
        ) );
		
		// Switch for back to top button
        $wp_customize->add_setting( 'back_to_top',
            array(
                'default' => $this->defaults['back_to_top'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'back_to_top',
            array(
                'label' => __( 'Back to Top Arrow', 'finbuzz' ),
                'section' => 'general_section',
            )
        ) );

        // Add our Preloader
        $wp_customize->add_setting('preloader',
			array(
			 'default'           => $this->defaults['preloader'],
			 'transport'         => 'refresh',
			 'sanitize_callback' => 'rttheme_switch_sanitization',
			)
        );
        $wp_customize->add_control(new Customizer_Switch_Control($wp_customize, 'preloader',
            array(
                'label'   => esc_html__('Preloader', 'finbuzz'),
                'section' => 'general_section',
            )
        ));
        $wp_customize->add_setting('preloader_image',
			array(
			  'default'           => $this->defaults['preloader_image'],
			  'transport'         => 'refresh',
			  'sanitize_callback' => 'absint',
			  'active_callback'   => 'rttheme_is_preloader_enabled',  
			)
        );
        $wp_customize->add_control(new WP_Customize_Media_Control($wp_customize, 'preloader_image',
			array(
				'label'         => esc_html__('Preloader Image', 'finbuzz'),
				'description'   => esc_html__('This is the description for the Media Control', 'finbuzz'),
				'section'       => 'general_section',
				'active_callback'   => 'rttheme_is_preloader_enabled',  
				'mime_type'     => 'image',
				'button_labels' => array(
					'select'       => esc_html__('Select File', 'finbuzz'),
					'change'       => esc_html__('Change File', 'finbuzz'),
					'default'      => esc_html__('Default', 'finbuzz'),
					'remove'       => esc_html__('Remove', 'finbuzz'),
					'placeholder'  => esc_html__('No file selected', 'finbuzz'),
					'frame_title'  => esc_html__('Select File', 'finbuzz'),
					'frame_button' => esc_html__('Choose File', 'finbuzz'),
				)
			)
        ));

        /**
         * Heading
         */
        $wp_customize->add_setting('social_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'social_heading', array(
            'label' => __( 'Contact And Social', 'finbuzz' ),
            'section' => 'general_section',
        )));
		
		// Contact		
		$wp_customize->add_setting( 'phone',
            array(
                'default' => $this->defaults['phone'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'phone',
            array(
                'label' => __( 'Phone', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'text',
            )
        );
		
        // email		
		$wp_customize->add_setting( 'email',
        array(
            'default' => $this->defaults['email'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
        )
        );
        $wp_customize->add_control( 'email',
            array(
                'label' => __( 'Email', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'text',
            )
        );
		
        //address

        $wp_customize->add_setting( 'address',
            array(
                'default' => $this->defaults['address'],
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_textarea_field',
            )
        );
        $wp_customize->add_control( 'address',
            array(
                'label' => __( 'Address', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'textarea',
            )
        );

        //opening hours

        $wp_customize->add_setting( 'opening_closing',
            array(
                'default' => $this->defaults['opening_closing'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_textarea_sanitization',
            )
        );
        $wp_customize->add_control( 'opening_closing',
            array(
                'label' => __( 'Opening-Closing Text', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'textarea',
            )
        );


        // Social link
        $wp_customize->add_setting( 'social_facebook',
            array(
                'default' => $this->defaults['social_facebook'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_facebook',
            array(
                'label' => __( 'Facebook', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
        $wp_customize->add_setting( 'social_twitter',
            array(
                'default' => $this->defaults['social_twitter'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_twitter',
            array(
                'label' => __( 'Twitter', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
        $wp_customize->add_setting( 'social_gplus',
            array(
                'default' => $this->defaults['social_gplus'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_gplus',
            array(
                'label' => __( 'Google Plus', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
        $wp_customize->add_setting( 'social_linkedin',
            array(
                'default' => $this->defaults['social_linkedin'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_linkedin',
            array(
                'label' => __( 'Linkedin', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
        $wp_customize->add_setting( 'social_behance',
            array(
                'default' => $this->defaults['social_behance'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_behance',
            array(
                'label' => __( 'Behance', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
        $wp_customize->add_setting( 'social_dribbble',
            array(
                'default' => $this->defaults['social_dribbble'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_dribbble',
            array(
                'label' => __( 'Dribbble', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
        $wp_customize->add_setting( 'social_youtube',
            array(
                'default' => $this->defaults['social_youtube'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_youtube',
            array(
                'label' => __( 'Youtube', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
		$wp_customize->add_setting( 'social_pinterest',
            array(
                'default' => $this->defaults['social_pinterest'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_pinterest',
            array(
                'label' => __( 'Pinterest', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
		$wp_customize->add_setting( 'social_instagram',
            array(
                'default' => $this->defaults['social_instagram'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_instagram',
            array(
                'label' => __( 'Instagram', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
		$wp_customize->add_setting( 'social_skype',
            array(
                'default' => $this->defaults['social_skype'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_skype',
            array(
                'label' => __( 'Skype', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
		$wp_customize->add_setting( 'social_rss',
            array(
                'default' => $this->defaults['social_rss'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_rss',
            array(
                'label' => __( 'RSS', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );
		
		$wp_customize->add_setting( 'social_snapchat',
            array(
                'default' => $this->defaults['social_snapchat'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_snapchat',
            array(
                'label' => __( 'Snapchat', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );

		$wp_customize->add_setting( 'social_tiktok',
            array(
                'default' => $this->defaults['social_tiktok'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
            )
        );
        $wp_customize->add_control( 'social_tiktok',
            array(
                'label' => __( 'Tiktok', 'finbuzz' ),
                'section' => 'general_section',
                'type' => 'url',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required  
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_General_Settings();
}
