<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
 
if ( is_404() || is_singular('team')) {
	$finbuzz_title = FinbuzzTheme::$options['error_title'];
} else if ( is_search() ) {
	$finbuzz_title = esc_html__( 'Search Results for : ', 'finbuzz' ) . get_search_query();
} else if ( is_home() ) {
	if ( get_option( 'page_for_posts' ) ) {
		$finbuzz_title = get_the_title( get_option( 'page_for_posts' ) );
	}
	else {
		$finbuzz_title = apply_filters( 'theme_blog_title', esc_html__( 'All Posts', 'finbuzz' ) );
	}
} else if ( is_archive() ) {
	$finbuzz_title = get_the_archive_title();
} else if ( is_page() ) {
	$finbuzz_title = get_the_title();
} else if ( is_single() ) {
	$finbuzz_title = get_the_title();
}

if ( !empty( FinbuzzTheme::$options['post_banner_title'] ) ){
	$post_banner_title = FinbuzzTheme::$options['post_banner_title'];
} else {
	$post_banner_title = esc_html__( 'Our News' , 'finbuzz' );
}
$banner_shape_img1='';
$banner_shape_img2='';
if( !empty( FinbuzzTheme::$options['banner_shape_img1']) && FinbuzzTheme::$options['banner_shape']) {
	$b1_bg = wp_get_attachment_image( FinbuzzTheme::$options['banner_shape_img1'], 'full');
	$banner_shape_img1 = $b1_bg;
}
if( !empty( FinbuzzTheme::$options['banner_shape_img2'] ) && FinbuzzTheme::$options['banner_shape'] ) {
	$b2_bg = wp_get_attachment_image( FinbuzzTheme::$options['banner_shape_img2'], 'full');
	$banner_shape_img2 = $b2_bg;
}

?>
<?php if ( FinbuzzTheme::$has_banner === 1 || FinbuzzTheme::$has_banner === "on" ): ?>
	<div class="entry-banner">
		<?php if ( FinbuzzTheme::$options['banner_shape'] ) { ?>
			<div class="banner-element wow fadeInLeft" data-wow-delay="400ms" data-wow-duration="800ms">
				<?php if($banner_shape_img1){
					 echo wp_kses( $banner_shape_img1, 'allow_link' ); 
				} else { ?>
				<img width="223" height="109" src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure79.png'; ?>" alt="<?php echo esc_attr( 'figure79','finbuzz' ); ?>">
				<?php } ?>
			</div>
			<div class="banner-element2 wow fadeInRight" data-wow-delay="400ms" data-wow-duration="800ms">
				<?php if($banner_shape_img2){
					echo wp_kses( $banner_shape_img2, 'allow_link' );
				} else { ?>
				<img  width="185" height="56" src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure78.png'; ?>" alt="<?php echo esc_attr( 'figure78','finbuzz' ); ?>">
				<?php } ?>
			</div>
		<?php } ?>
		<div class="container">
			<div class="entry-banner-content">
				<?php if(is_singular('finbuzz_team')){ ?>
					<h1 class="entry-title"><?php _e("Team Details","finbuzz"); ?></h1>
				<?php } else if ( is_single() ) { ?>
				<h1 class="entry-title"><?php echo wp_kses( $finbuzz_title , 'alltext_allow' );?></h1>
				<?php } else if ( is_page() ) { ?>
					<h1 class="entry-title"><?php echo wp_kses( $finbuzz_title , 'alltext_allow' );?></h1>
				<?php } else { ?>
					<h1 class="entry-title"><?php echo wp_kses( $finbuzz_title , 'alltext_allow' );?></h1>
				<?php } ?>
				<?php if ( FinbuzzTheme::$has_breadcrumb == 1 ) { ?>
					<?php get_template_part( 'template-parts/content', 'breadcrumb' );?>
				<?php } ?>
			</div>
		</div>
	</div>
<?php endif; ?>