<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size8';
$id = get_the_ID();

$position   	= get_post_meta( $id, 'finbuzz_team_position', true );
$content = get_the_content();
$content = apply_filters( 'the_content', $content );
$content = wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['team_arexcerpt_limit'], '' );
?>
<article id="post-<?php the_ID(); ?>">
	<div class="rtin-item " >
		<div class="rtin-content-wrap">		
			<div class="rtin-thums">
				<a href="<?php the_permalink();?>">
					<?php
					if ( has_post_thumbnail() ){
						the_post_thumbnail( $thumb_size );
					}
					else {
						if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
							echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
						}
						else {
							echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
						}
					}
					?>
				</a>
			</div>
			<div class="rtin-content">
				<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
				<?php if ( FinbuzzTheme::$options['team_ar_position'] ) { ?>
				<div class="rtin-designation"><?php echo esc_html( $position );?></div>
				<?php } if ( FinbuzzTheme::$options['team_ar_excerpt'] ) { ?>
				<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
				<?php } ?>
				<?php if(FinbuzzTheme::$options['team_ar_button']){ ?>
					<div class="item-button">
						<a href="<?php the_permalink();?>" class="btn-style4">+ <span>Read More</span></a>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</article>