<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();

// Logo

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
	$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
	$finbuzz_dark_logo = $logo_dark;
}else {
	$finbuzz_dark_logo = "<img width='152' height='45' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

if( !empty( FinbuzzTheme::$options['logo_light'] ) ) {
	$logo_lights = wp_get_attachment_image( FinbuzzTheme::$options['logo_light'], 'full' );
	$finbuzz_light_logo = $logo_lights;
}else {
	$finbuzz_light_logo = "<img width='152' height='45' src='" . FINBUZZ_IMG_URL . 'logo-light.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>";
}

?>
<div id="rt-sticky-placeholder"></div>
<div class="header-menu mobile-menu menu-layout1" id="header-menu">
	<div class="container">
		<div class="menu-full-wrap">
			<div class="d-flex align-items-center justify-content-between">
				<div>
					<div class="site-branding">
						<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
							<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_light_logo, 'allow_link' ); ?></a>
					</div>
				</div>
				<div>
					<div class="menu-wrap">
						<div id="site-navigation" class="main-navigation">
							<?php wp_nav_menu( $nav_menu_args );?>
						</div>
					</div>
				</div>
				<div class="d-flex">
					<ul class="info-wrap">
						<?php if ( FinbuzzTheme::$options['search_icon'] ) { ?>
							<li class="search-btn">
								<?php get_template_part( 'template-parts/header/icon', 'search' ); ?>
							</li>
						<?php } ?>
						<?php if ( FinbuzzTheme::$options['phone'] ) { ?>
							<li class="header-number">
								<div class="media">
									<div class="item-icon"><i class="far fa-comments"></i></div>
									<div class="media-body">
										<?php $header_hotline_txt = finbuzzTheme::$options['header_hotline_txt']; ?>
										<?php if ( !empty( $header_hotline_txt ) ){?>
											<div class="item-label"><?php echo esc_html( $header_hotline_txt ); ?> </div>
										<?php }
										else { esc_html_e( '', 'finbuzz' ); } ?>
										<a href="tel:<?php echo esc_attr( FinbuzzTheme::$options['phone'] );?>" class="item-number">
										<?php echo wp_kses( FinbuzzTheme::$options['phone'] , 'alltext_allow' );?>
										</a>
									</div>
								</div>
							</li>
						<?php } ?>	
					</ul>
					<?php if ( FinbuzzTheme::$options['vertical_menu_icon']){ ?>
							<div class="vertical-menu">
								<?php get_template_part( 'template-parts/header/icon', 'menu' ); ?>
							</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</div>