<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$Finbuzz_socials = FinbuzzTheme_Helper::socials();
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="top-bar-wrap">
			<div class="tophead-left">
			<?php if ( FinbuzzTheme::$options['address'] ) { ?>
				<div class="address">
					<i class="flaticon-pin"></i><?php echo wp_kses( FinbuzzTheme::$options['address'] , 'alltext_allow' );?>
				</div>
			<?php } ?>	
			</div>
			<div class="tophead-right">
				<?php if ( FinbuzzTheme::$options['email'] ) { ?>
					<div class="email single-info">
						<i class="flaticon-big-envelope"></i><a href="mailto:<?php echo esc_attr( FinbuzzTheme::$options['email'] );?>"><?php echo wp_kses( FinbuzzTheme::$options['email'] , 'alltext_allow' );?></a>
					</div>
				<?php } ?>
				<?php if ( FinbuzzTheme::$options['phone'] ) { ?>
                    <div class="info-phone single-info "><span class="info-text"><i class="flaticon-telephone"></i><a href="tel:<?php echo esc_attr(FinbuzzTheme::$options['phone']) ?>"><?php echo wp_kses( FinbuzzTheme::$options['phone'] , 'alltext_allow' ); ?></a></div>
                <?php } ?>
				<?php if ( FinbuzzTheme::$options['online_button'] == '1' && !empty(FinbuzzTheme::$options['online_button_text'])) { ?>
					<div class="header-button">
						<i class="flaticon-calendar"></i>
						<a target="_self" href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>"><?php echo esc_html( FinbuzzTheme::$options['online_button_text'] );?></a>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</div>