<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$finbuzz_socials = FinbuzzTheme_Helper::socials();

$finbuzz_mobile_meta  = (FinbuzzTheme::$options['mobile_header_phone'] ||  FinbuzzTheme::$options['mobile_header_social'] && $finbuzz_socials ||  FinbuzzTheme::$options['mobile_header_make_claim'] ) ? true : false;

?>
<?php if ( $finbuzz_mobile_meta) { ?>
<div class="mobile-top-bar" id="mobile-top-fix">
	<div class="header-top">
		<div>
			<?php if(FinbuzzTheme::$options['phone'] && FinbuzzTheme::$options['mobile_header_phone']) { ?>
				<div class="info-phone header-info "><span><i class="flaticon-telephone"></i><a href="tel:<?php echo esc_attr( FinbuzzTheme::$options['phone'] );?>"><?php echo wp_kses( FinbuzzTheme::$options['phone'] , 'alltext_allow' );?></a></span>
			</div>
			<?php } ?>
		</div>
	</div>
	<?php if ( FinbuzzTheme::$options['mobile_header_cart_icon'] ) { ?>			
        <?php get_template_part( 'template-parts/header/icon', 'cart' );
    } ?>
	<?php if( $finbuzz_socials !='' && FinbuzzTheme::$options['mobile_header_social']) { ?>
		<ul class="header-social">
			<?php foreach ( $finbuzz_socials as $finbuzz_social ): ?>
				<li><a target="_blank" href="<?php echo esc_url( $finbuzz_social['url'] );?>"><i class="fab <?php echo esc_attr( $finbuzz_social['icon'] );?>"></i></a></li>
			<?php endforeach; ?>
		</ul>
	<?php } ?>
	<?php if( FinbuzzTheme::$options['online_button_text'] && FinbuzzTheme::$options['mobile_header_make_claim']) { ?>
		<div class="header-button">
				<a target="_self" href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>"><?php echo esc_html(FinbuzzTheme::$options['online_button_text']);?></a>
		</div>
	<?php } ?>	
</div>
<?php } ?>
